$(function() {
	
	loadData();
	
});

function moveUp(id,rank,catid)
{
	$.post("json/moveUp.php",
	  {
		record_id:id,
		record_rank:rank,
		record_catid:catid
	  },
	  function(data,status){
		loadData();
	  });
}

function moveDown(id,rank,catid)
{
	$.post("json/moveDown.php",
	  {
		record_id:id,
		record_rank:rank,
		record_catid:catid
	  },
	  function(data,status){
		loadData();
	  });
}



function loadData()
{
	var serializedData = $("#form1").serialize();
	$.ajax({
		url: "json/getData.php",
		type: "GET",
		data: serializedData,
		dataType: "jsonp",
		success: function(data){
			var total = data.total;
			var str = '';
			if(total>0){
				$('#dataTableBody').empty();
				var previd = data[0].category_id;
				for(var i=0; i<total; i++){
					
					var memberStatus = "";
					if(data[i].subcategory_status == 1)
					{
						memberStatus = '<span class="label label-sm label-success">Active</span>';	
					}else{
						memberStatus = '<span class="label label-sm label-danger">Inactive</span>';	
					}
					if(i == 0 || (previd != data[i].category_id)){
						moveupbutton = '<a href="#" class="btn default btn-xs yellow-stripe disabled">Move Up</a>';
					}else{
						moveupbutton = '<a href="javascript:moveUp('+data[i].subcategory_id+','+data[i].subcategory_rank+','+data[i].category_id+');" class="btn default btn-xs yellow-stripe">Move Up</a>';
					}
					if(i == total-1 || (data[i].category_id != data[i+1].category_id)){
						movedownbutton = '<a href="#" class="btn default btn-xs blue-stripe disabled">Move Down</a>';
					}else{
						movedownbutton = '<a href="javascript:moveDown('+data[i].subcategory_id+','+data[i].subcategory_rank+','+data[i].category_id+');" class="btn default btn-xs blue-stripe">Move Down</a>';
					}
					previd = data[i].category_id;
					
					str = '<tr><td>'+(i+1)+'</td><td align="center"><a href="../../images/'+data[i].subcategory_image+'" class="fancybox-button"><i class="icon-picture"></i></a></td><td>'+data[i].category_title+'</td><td>'+data[i].subcategory_title+'</td><td>'+memberStatus+'</td><td>'+moveupbutton+movedownbutton+'<a href="update.php?recordid='+data[i].subcategory_id+'" class="btn default btn-xs green-stripe">Edit</a><a href="javascript:deleteItemTrigger('+data[i].subcategory_id+');" class="btn default btn-xs red-stripe">Delete</a></td></tr>';
					$('#dataTable > tbody:last').append(str);
				}
				
				
			}else{
			}
		},
		error: function(){
		}
	});
}